TITLE 							                   {exa085.pde }
   'Conduction in a Rectangular Plate (Cu/Fe)'
SELECT
   errlim=3e-4     ngrid=1     spectral_colors
VARIABLES
   U
DEFINITIONS
   Lx=1     Ly=1     cond=5.99e7				{ Conductivity }
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Jx=cond*Ex     Jy=cond*Ey     J=cond*E     Jm=magnitude(J)
   J_angle=sign( Jy)*arccos( Jx/Jm)/pi*180
EQUATIONS
   div( J)=0
BOUNDARIES
region 'domain'        			               		{ Copper }
   start 'boundary' (0,-Ly)   value( U)=0 line to (Lx,-Ly)  to (Lx,0)
   natural(U)=0   line to (Lx,Ly)   to  (0,Ly)		{ Insulated }
   value(U)=1.0  line to (-Lx,Ly)   to (-Lx,0)
   natural (U)=0  line to (-Lx,-Ly)  close      		{ Insulated }
region 'iron'   cond=1.03e7    				
   start(-Lx,-Ly)  line to (Lx,-Ly) to (Lx,0) to (-Lx,0) close
PLOTS
   contour( U)    elevation( U) on 'boundary'
   elevation( normal( J)) on 'boundary'
   vector( J) norm    contour( J_angle) painted
   contour( Ex) painted zoom(-Lx/2,-Ly/2,  Lx, Ly)
   contour( Ey) painted zoom(-Lx/2,-Ly/2,  Lx, Ly)
   contour( Jx) painted zoom(-Lx/2,-Ly/2,  Lx, Ly)
   contour( Jy) painted zoom(-Lx/2,-Ly/2,  Lx, Ly)
END


